﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace AZVIC.Ei8htPOS.POSRetail.Controls
{
    /// <summary>
    /// Interaction logic for UserPrompt.xaml
    /// </summary>
    public partial class UserPrompt : Window
    {
      

        public UserPrompt(string question, string title, string defaultValue = "")
        {
            InitializeComponent();
            this.Loaded += new RoutedEventHandler(PromptDialog_Loaded);
            txtQuestion.Text = question;
            Title = title;
            txtResponse.Text = defaultValue;
           

        }

        void PromptDialog_Loaded(object sender, RoutedEventArgs e)
        {
                txtResponse.Focus();
        }

        public static string Prompt(string question, string title, string defaultValue = "", InputType inputType = InputType.Text)
        {
            UserPrompt inst = new UserPrompt(question, title, defaultValue);
            inst.ShowDialog();
            if (inst.DialogResult == true)
                return inst.ResponseText;
            return null;
        }

        public string ResponseText
        {
            get
            {
                    return txtResponse.Text;
            }
        }

        protected void btnCancel_Click(object sender, RoutedEventArgs e)
        {
            DialogResult = false;
            Close();
        }

        private void btnOk_Click(object sender, RoutedEventArgs e)
        {
            DialogResult = true;
            Close();
        }
        protected void Keypad_Click(object sender, RoutedEventArgs e)
        {
            Button key = sender as Button;
            txtResponse.AppendText(key.Content.ToString());
            txtResponse.CaretIndex = txtResponse.Text.Length;
            txtResponse.Focus();
        }

        private void btnBackspace_Click(object sender, RoutedEventArgs e)
        {
            if (!string.IsNullOrEmpty(txtResponse.Text))
            {
                txtResponse.Text = txtResponse.Text.Substring(0, txtResponse.Text.Length - 1);
                txtResponse.CaretIndex = txtResponse.Text.Length;
            }
        }

    }
}
